Shader "SPP/MatCap"
{
	Properties
	{
		_Color ("Color", Color) = (0.5,0.5,0.5,1)
		_LightColor ("Light Color", Color) = (1.0,1.0,1.0,1)
		_AmbientColor ("Ambient Color", Color) = (0.2,0.2,0.2,1)
		_MatCap ("MatCap (RGB)", 2D) = "white" {}
		_Shininess ("Shininess", Range (0.01, 1)) = 0.078125
	}
	
	SubShader
	{
		Tags { "RenderType"="Opaque" }
		LOD 200
		
		CGPROGRAM
		
		#pragma surface surf Lambert vertex:vert 
		
		//sampler2D _MainTex;
		sampler2D _MatCap;
		float4 _Color;
		float4 _LightColor;
		float4 _AmbientColor;
		float _Shininess;
		
		struct Input
		{
			float2 matcapUV;
		};
		
		void vert (inout appdata_full v, out Input o)
		{
			UNITY_INITIALIZE_OUTPUT(Input,o);
			
			float3 worldNorm = normalize(unity_WorldToObject[0].xyz * v.normal.x + unity_WorldToObject[1].xyz * v.normal.y + unity_WorldToObject[2].xyz * v.normal.z);
			worldNorm = mul((float3x3)UNITY_MATRIX_V, worldNorm);
			o.matcapUV = worldNorm.xy * 0.5 + 0.5;
		}
		
		void surf (Input IN, inout SurfaceOutput o)
		{
			half4 mc = tex2D(_MatCap, IN.matcapUV);
			o.Albedo = mc.rgb * _Color.rgb * 2.0; // _Shininess + _AmbientColor werden nicht benutzt

		}
		ENDCG
	}
	
	Fallback "VertexLit"
}
